# 環境チェックおよび起動スクリプト (Check & Start)

$ErrorActionPreference = "Stop"

Write-Host "============================" -ForegroundColor Cyan
Write-Host " Karaage Browser 環境チェック" -ForegroundColor Cyan
Write-Host "============================" -ForegroundColor Cyan

# 1. Check Python Installation
Write-Host "Checking for Python..." -NoNewline
try {
    $pythonVersion = python --version 2>&1
    if ($LASTEXITCODE -eq 0) {
        Write-Host " OK ($pythonVersion)" -ForegroundColor Green
    } else {
        Write-Host " FAILED" -ForegroundColor Red
        Write-Host "Python is required to run the local server. Please install Python 3.x." -ForegroundColor Yellow
        exit 1
    }
} catch {
    Write-Host " FAILED" -ForegroundColor Red
    Write-Host "Python command not found. Please install Python or add it to PATH." -ForegroundColor Yellow
    exit 1
}

# 2. Check current directory
if (!(Test-Path "karaage-browser/index.html")) {
    Write-Host "Warning: karaage-browser/index.html not found in the current directory." -ForegroundColor Yellow
    Write-Host "Make sure you are running this script from the project root." -ForegroundColor Yellow
}

# 3. Start the Server
$port = 8000
Write-Host "`nStarting Local Server on port $port..." -ForegroundColor Cyan

try {
    # Check if port is already in use
    $portInUse = Get-NetTCPConnection -LocalPort $port -ErrorAction SilentlyContinue
    if ($portInUse) {
        Write-Host "Port $port is already in use. Assuming the Karaage Server is already running!" -ForegroundColor Green
    } else {
        Write-Host "Running: python -m http.server $port"
        Start-Process -NoNewWindow -FilePath "python" -ArgumentList "-m http.server $port"
        Write-Host "Server started." -ForegroundColor Green
    }
} catch {
    Write-Host "Failed to start server: $_" -ForegroundColor Red
}

Write-Host "`nAll checks passed. You can now use [Alt+K] to launch Karaage Browser in the editor!" -ForegroundColor Green
Write-Host "============================" -ForegroundColor Cyan
