# Troubleshooting Karaage Browser

## 1. Context: Cross-Origin Resource Sharing (CORS) & Iframes

A common issue when developing tools that interact with `<iframe>` contents is the Same-Origin Policy.

### The Problem
If you open Karaage Browser directly by double-clicking `index.html` (which opens as `file:///.../index.html`), and the iframe loads `file:///.../sample.html`, modern browsers (like Chrome, Edge) treat different `file:///` URLs as distinct origins for security reasons.
When `script.js` attempts to read `iframe.contentDocument` or access `history`, the browser throws a **SecurityError (DOMException)**.

### The Solution: Local Web Server
To bypass this restriction, the Karaage Browser MUST be served over `http://localhost`. When both the `index.html` (Shell) and `sample.html` (Target) are served from `http://localhost:8000`, they share the exact same origin, and the browser allows deep inspection of the inside pages.

**Fix**: Always run the `python -m http.server 8000` via the `Launch_Karaage.ps1` script before using the browser.

## 2. Navigating to External Websites (e.g., google.com)
If a user types `https://google.com` into the Karaage URL bar, the iframe will load Google. 
However, **Inspector Mode will instantly fail**. 
Because Google's origin (`https://google.com`) does not match the host origin (`http://localhost:8000`), the browser will completely block JavaScript from seeing inside the iframe to protect user privacy.

**Limitation**: Karaage Browser can only inspect local files hosted on the same local server.

## 3. Empty Layout / Code Panels
If the Inspector is highlighting elements but the Code or Layout numbers don't appear, this is usually caused by an uncaught JavaScript error terminating the execution sequence before the tabs are populated. Check the Antigravity Developer Tools console (Help > Toggle Developer Tools) for `TypeError` or `ReferenceError` inside `script.js`.
