#Requires -Version 5.1
$ErrorActionPreference = "Stop"

Write-Host "==============================================" -ForegroundColor Cyan
Write-Host "   Karaage Browser Launcher for Antigravity" -ForegroundColor White
Write-Host "==============================================" -ForegroundColor Cyan
Write-Host ""

# 1. Check for Python Installation
Write-Host "[1/2] Checking system requirements..." -ForegroundColor Yellow
if (-not (Get-Command "python" -ErrorAction SilentlyContinue)) {
    Write-Host ""
    Write-Host "[!] Python is not installed on your system." -ForegroundColor Red
    Write-Host "Karaage Browser requires Python to run the local server." -ForegroundColor Yellow
    $install = Read-Host "Would you like to automatically install Python now? (Y/N)"
    
    if ($install -match '^[yY]$') {
        Write-Host "Installing Python via winget... Please wait (this may take a few minutes)." -ForegroundColor Cyan
        winget install -e --id Python.Python.3.12 --accept-package-agreements --accept-source-agreements
        Write-Host "Python installed successfully! Please restart this script." -ForegroundColor Green
        Read-Host "Press Enter to exit..."
        exit
    }
    else {
        Write-Host "Installation cancelled. You must install Python manually to run Karaage Browser." -ForegroundColor Red
        Read-Host "Press Enter to exit..."
        exit
    }
}
else {
    $pyVersion = (python --version) 2>&1
    Write-Host "- Found: $pyVersion" -ForegroundColor Green
}
Write-Host ""

# 2. Start UI Server
Write-Host "[2/2] Starting Development Server on Port 8000..." -ForegroundColor Yellow
# kill existing python server on port 8000 if any
Get-Process python -ErrorAction SilentlyContinue | Where-Object { $_.MainWindowTitle -eq "" } | Stop-Process -Force -ErrorAction SilentlyContinue

$uiProcess = Start-Process -FilePath "python" -ArgumentList "-m http.server 8000" -WindowStyle Hidden -PassThru

Write-Host ""
Write-Host "Server is running successfully!" -ForegroundColor Green
Write-Host "----------------------------------------------"
Write-Host "ACCESS URLS:" -ForegroundColor Cyan
Write-Host "1. Main Browser: http://localhost:8000/index.html"
Write-Host "2. Karaage V2  : http://localhost:8000/karaage_v2.html"
Write-Host "3. Karaage V1  : http://localhost:8000/karaage_v1.html"
Write-Host ""
Write-Host "HOW TO USE IN ANTIGRAVITY:" -ForegroundColor Cyan
Write-Host "1. Press Ctrl + Shift + P"
Write-Host "2. Type 'Simple Browser: Show' and Enter"
Write-Host "3. URL: http://localhost:8000/index.html"
Write-Host ""
Write-Host "TIPS:" -ForegroundColor Magenta
Write-Host "- If you see a 404 error, try pressing 'Ctrl + F5' in the browser."
Write-Host "- Do NOT use 'C:\Users...' paths in the URL bar."
Write-Host "----------------------------------------------"
Write-Host ""

Write-Host "Press any key to stop the server and exit..." -ForegroundColor DarkGray
$null = $Host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")

# Cleanup
Write-Host "Stopping server..." -ForegroundColor Yellow
Stop-Process -Id $uiProcess.Id -Force -ErrorAction SilentlyContinue
Write-Host "Closed. Goodbye!" -ForegroundColor Green
