# SDK Verification Guide

gcloud SDK が正常に動作するか、適切なプロジェクトが設定されているかを確認する手順です。

## 1. インストールとバージョンの確認
```powershell
gcloud --version
```

## 2. 認証状態の確認
現在ログインしているアカウントを表示します。
```powershell
gcloud auth list
```
もしアクティブなアカウントがない場合は以下を実行：
```powershell
gcloud auth login
```

## 3. プロジェクト設定の確認
```powershell
gcloud config get-value project
```
プロジェクトを切り替える場合：
```powershell
gcloud config set project [PROJECT_ID]
```

## 4. リージョン内のサービス一覧取得（導通テスト）
```powershell
gcloud run services list --region=asia-northeast1
```
