## UniDic 辞書の用意について

MorphFoundry では辞書を同梱していません。国立国語研究所が **Apache License 2.0** で公開している「UniDic 現代書き言葉（CSV 版）」をダウンロードし、`unidic-converter.js` を使って JSON に変換してから利用してください。

### ダウンロード（CSV 版の場所）

1. [UniDic ダウンロードページ](https://clrd.ninjal.ac.jp/unidic/) を開きます。
2. 「最新版ダウンロード」にある **現代書き言葉 UniDic（CSV 版）** のリンク（例: `unidic-2024.4.17.zip`）を選択します。  
   ※「解析に利用する場合に適した軽量版（バイナリ）」は MeCab 用で CSV を含まないので注意。
3. ライセンスに同意して Zip をダウンロードし、展開します。中に `lex.csv` が含まれています。
4. バックナンバーに掲載されている `unidic-cwj-202302_full.zip` のようなフルパッケージにも `lex.csv` が同梱されています。最新版が公開直後に見つからない場合は、こちらのフル版を取得しても構いません。

### JSON への変換

```bash
# 例: 約3割（263,040件）だけ取り込んだ軽量辞書を生成する場合
node ../unidic-converter.js /path/to/unidic-2024.4.17/lex.csv ./dictionaries/unidic-lite.json 263040
```

- 第3引数で取り込み件数を調整できます。数値を変えれば、目的に合わせたサブセット辞書を作成できます。
- 出力された `dictionaries/unidic-lite.json` はエントリ数 263,040 の軽量版で、ブラウザデモでも扱いやすいサイズです。
- 第3引数を省略すると全件を取り込みますが、数百万行になるため最初は小さめの件数でテストすることを推奨します。

#### フルデータを生成する場合

最新版の `lex.csv` をすべて取り込みたいときは、第3引数を省略して実行します。

```bash
node ../unidic-converter.js /path/to/unidic-2024.4.17/lex.csv ./dictionaries/unidic-full.json
```

- 生成される `unidic-full.json` は 100MB 超となり、ロード時にも相応のメモリを消費します。ブラウザで利用する場合はストレージ容量や読み込み時間に注意してください。
- CLI や Node.js から利用する際は `createMorphFoundry({ defaultDictionaries: ['dictionaries/unidic-lite.json'] })` のように指定し、必要に応じてフル版に切り替えてください。
- `entryCount` や `createdAt` が JSON のメタ情報に含まれるため、変換後に内容を確認しやすくなっています。語彙数が期待通りかどうかは `entryCount` を見ると素早く判断できます。

### ライセンス表記

UniDic は Apache License 2.0 です。生成した JSON と一緒に、UniDic に含まれる `LICENSE` や `README` を同梱し、配布条件に従ってクレジットを明記してください。MorphFoundry 本体も Apache 2.0 ですが、辞書のライセンスは別途遵守する必要があります。
