# MorphFoundry 0.1.0

ブラウザとNode.jsの双方で動作する、教育目的の日本語形態素解析ライブラリです。

## セットアップ（ブラウザ）

```html
<script type="module">
  import { createMorphFoundry } from './morphfoundry.js';

  const analyzer = await createMorphFoundry({
    // UniDic を変換して作成した JSON を指定する
    defaultDictionaries: ['./dictionaries/unidic-lite.json']
  });

  console.log(analyzer.analyze('形態素解析を試す'));
</script>
```

## セットアップ（Node.js / CLI）

```bash
node --input-type=module -e "const { createMorphFoundry, analyzeToTable } = await import('./articles/midori227_1/morphfoundry.js'); const analyzer = await createMorphFoundry({ defaultDictionaries: ['articles/midori227_1/dictionaries/unidic-lite.json'] }); console.log(await analyzeToTable(analyzer, 'UniDicで解析テスト。'));"
```

## 主な機能

- IPA辞書互換JSONからのロード
- 動的に追加できるユーザー辞書
- 簡易的なViterbi探索による最小コスト系列の決定
- Web Worker / CLI で再利用しやすいユーティリティ
- listDictionaries() でロード済み辞書の語彙数・エントリ数を確認可能（軽量辞書は entryCount: 263040、フル辞書は entryCount: 876802）

> UniDic は CSV 版をダウンロードして `unidic-converter.js` で JSON 化してください。バイナリ版 (`sys.dic` など) には CSV が含まれないため変換できません。

## フォルダー構成

```
.
├── morphfoundry.js              # ライブラリ本体
├── dictionaries/
│   ├── unidic-lite.json        # UniDic から約3割（263,040件）を取り込んだ軽量版
│   └── unidic-full.json        # UniDic を全件取り込んだ高精度版
├── data.csv                    # 旧サイトから移行した301件のコンテンツメタデータ
└── README-morphfoundry.md      # このファイル
```

## ライセンス

- ライブラリ: Apache License 2.0
- 辞書データ: UniDic（国立国語研究所）

本番利用を想定する場合は、辞書のライセンス条項を必ず確認し、最新の辞書データに置き換えてください。辞書の作り方は `dictionaries/README.md` を参照してください。

## 実データサンプルの解析

- `data.csv` の説明文を MorphFoundry + UniDic で解析するデモを `demo9-realdata-csv-analyzer.html` に用意しています。
- 解析ボタンを押すと 301 件のテキストを数秒で走査し、上位名詞・カテゴリ分布を可視化します。
- 自前の CSV を試す場合は同じ列構成（カテゴリ / パス / 日付 / 説明 / メディア）に揃えて差し替えるだけで再利用可能です。

